/***************************************************************************
*
* Copyright 2010,2011 BMW Car IT GmbH
*
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*        http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
****************************************************************************/

#ifndef _SURFACEGETIPACCEPTANCECOMMAND_H_
#define _SURFACEGETIPACCEPTANCECOMMAND_H_

#include "ilm_types.h"
#include "ICommand.h"

class SurfaceGetIpAcceptanceCommand : public ICommand
{
public:
    SurfaceGetIpAcceptanceCommand(pid_t sender, const unsigned int givenid, t_ilm_string **pSeats, unsigned int *num_seats)
    : ICommand(ExecuteSynchronous, sender)
    , m_idtoSet(givenid)
    {
        m_pSeatArray = pSeats;
        m_psizeSeatArray = num_seats;
    }

    /**
     * \brief default destructor
     */
    virtual ~SurfaceGetIpAcceptanceCommand()
    {
    }

    /**
     * \brief Execute this command.
     * \param[in] executor Pointer to instance executing the LayerManagement COmmands
     * \return ExecutionSuccess: execution successful
     * \return ExecutionSuccessRedraw: execution successful and screen needs to be redrawn
     * \return ExecutionFailed: execution failed
     * \return ExecutionFailedRedraw: execution unsuccessful and screen needs to be redrawn
     */
    virtual ExecutionResult execute(ICommandExecutor* executor);

    /**
     * \brief Get description string for this command.
     * \return String object with description of this command object
     */
    virtual const std::string getString();

private:
    const unsigned int m_idtoSet;
    char ***m_pSeatArray;
    unsigned int *m_psizeSeatArray;
};

#endif /* _SURFACEGETIPACCEPTANCECOMMAND_H_ */
